function cterm = calccterm(crep, wout, wdata, signeddata)
%cterm = calccterm(crep, wout, wdata, signeddata)
%
%Calculates correction vector for a given coefficient representation,
%data wordlength and signedness.
%Inputs:
%  creps - structure generated by gencoeffreps
%  class - the class to choose from: 'bin' or 'msd'
%  rep - ID of the representation if the class has multiple
%        representations. Needed for 'msd'.
%Outputs:
%  crep - structure describing the chosen representation

%Copyright (C) 2008 Anton Blad, Oscar Gustafsson.
%This file is licensed under a modified version of GPL v2, see the file
%LICENSE for details.

coeffs = crep.coeffs;

datasigns = zeros(1, wdata);
if signeddata == 1
	datasigns(1) = 1;
end

pcoeffs = sum(coeffs == 1);
ncoeffs = sum(coeffs == -1);

negterm = conv(pcoeffs, datasigns) + conv(ncoeffs, not(datasigns));

cterm = conv(negterm, ones(1, wout));

s = 0;
for n = length(cterm):-1:1
	t = mod(cterm(n)+s, 2);
	s = (cterm(n)+s-t)/2;
	cterm(n) = t;
end

cterm = cterm(end-wout+1:end);

